-- File generated with srec2prom.exe  DO NOT EDIT THIS FILE!
-- Copyright (C) 2019  Dr. Uwe Meyer-Baese.
-- =======================================================
LIBRARY ieee;
USE ieee.STD_LOGIC_1164.ALL;
USE ieee.STD_LOGIC_arith.ALL;
USE ieee.STD_LOGIC_unsigned.ALL;
-- =======================================================
ENTITY rom4096x32 IS
PORT (clk   : IN STD_LOGIC;      -- System clock
      reset : IN STD_LOGIC;      -- Asynchronous reset
      pma   : IN STD_LOGIC_VECTOR(11 DOWNTO 0); -- Program memory address
      pmd   : OUT STD_LOGIC_VECTOR(31 DOWNTO 0)); -- Program memory data
END ENTITY rom4096x32;
-- =======================================================
ARCHITECTURE fpga OF rom4096x32 IS
-- Program ROM definition and values
TYPE MEMP IS ARRAY (0 TO 4095) OF STD_LOGIC_VECTOR(31 DOWNTO 0);
CONSTANT prom : MEMP := (
X"0037883A", --1 _start:  add     sp, r0, r0
X"06D00004", --2         addi    sp, r0, 0x4000  /* mem size stack pointer */ 
X"DEFFFF04", --3         addi    sp, sp, -0x4
X"0001883A", --4         add     r0, r0, r0
X"0001883A", --5         add     r0, r0, r0
X"0035883A", --6         add     gp, r0, r0    
X"06822B04", --7         addi    gp, r0, 0x08AC  /* initial global pointer */
X"0031883A", --8         add     et, r0, r0
X"0601EC04", --9         addi    et, r0, 0x07B0  /* initial et pointer */       
X"0005883A", --10         add     r2, r0, r0
X"00801F04", --11         addi    r2, r0, 0x007C  /* set main entry */        
X"1000683A", --12         jmp     r2
X"29400044", --13 level3: addi    r5, r5, 0x1       /* s1=s1+1 */
X"21400315", --14         stw     r5, 12(r4)        /* array[3] = s1 */
X"F800283A", --15         ret                       /* level3 ends */
X"DEFFFF04", --16 level2: addi    sp, sp, -0x4
X"DFC00015", --17         stw     ra, 0(sp)         /* save the return address */
X"294B883A", --18         addi    r5, r5, r5       /* s1=s1+s1 */
X"21400215", --19         stw     r5, 8(r4)        /* array[2] = s1 */
X"00000300", --20         call    level3       
X"DFC00017", --21         ldw     ra, 0(sp)         /* restore ra */
X"DEC00104", --22         addi    sp, sp, 0x4       /*restore sp */
X"F800283A", --23         ret                       /* level2 ends */
X"DEFFFF04", --24 level1: addi    sp, sp, -0x4
X"DFC00015", --25         stw     ra, 0(sp)         /* save the return address */
X"29400044", --26         addi    r5, r5, 0x1       /* s1=s1+1 */
X"21400115", --27         stw     r5, 4(r4)        /* array[1] = s1 */
X"000003C0", --28         call    level2       
X"DFC00017", --29         ldw     ra, 0(sp)         /* restore ra */
X"DEC00104", --30         addi    sp, sp, 0x4       /*restore sp */
X"F800283A", --31         ret                       /* level1 ends */
X"DEFFF104", --32 main:   addi    sp, sp, -0x3C     /* make space on sp */
X"DFC00E15", --33         stw     ra, 56(sp)        /* put ra in memory */
X"00848CC4", --34         addi    r2, zero, 0x1233  /* s1=0x1233 */        
X"D8800035", --35         stwio   r2, 0(sp)         /* save s1 */
X"D9400037", --36 loop:   ldwio   r5, 0(sp)
X"D9000304", --37         addi    r4, sp, 0xC
X"000005C0", --38         call    level1 
X"D8800417", --39         ldw     r2, 16(sp)        /* s1 = array[1] */
X"D8800035", --40         stwio   r2, 0(sp)
X"D8800517", --41         ldw     r2, 20(sp)        /* s2 = array[2] */
X"D8800135", --42         stwio   r2, 4(sp)
X"D8800617", --43         ldw     r2, 24(sp)        /* s3 = array[3] */
X"D8800235", --44         stwio   r2, 8(sp)
X"003FF606", --45         br      loop             /* start loop again */
OTHERS => X"00000001"); -- default jump to 0

BEGIN
-- The following process will be mapped to a BlockRAM for Zynq/Virtex/Spartan
-- devices (if addr > 4 bit!) and to Distributed RAM in all other cases

prog_rom: PROCESS (reset, clk)
BEGIN
  IF reset = '0' THEN               -- Asynchronous clear
    pmd <= (OTHERS => '0');     
  ELSIF rising_edge(clk) THEN
      pmd <= prom(CONV_INTEGER(pma)); -- Read from ROM
  END IF;
END PROCESS;

END ARCHITECTURE fpga;
